/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal;

import com.aptana.debug.core.IExtendedStreamsProxy;
import com.aptana.js.debug.core.internal.OutputStreamMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamsProxy
implements IExtendedStreamsProxy {
    private final Map<String, OutputStreamMonitor> monitorMap = new HashMap<String, OutputStreamMonitor>();

    public StreamsProxy(InputStream outIn, InputStream errIn, IProcess process) {
        String encoding = this.getEncoding(process);
        this.monitorMap.put("ID_STANDARD_OUTPUT_STREAM", this.createStreamMonitor(outIn, encoding, process));
        this.monitorMap.put("ID_STANDARD_ERROR_STREAM", this.createStreamMonitor(errIn, encoding, process));
        for (OutputStreamMonitor monitor : this.monitorMap.values()) {
            monitor.startMonitoring();
        }
    }

    public StreamsProxy(Map<String, InputStream> streams, IProcess process) {
        String encoding = this.getEncoding(process);
        for (Map.Entry<String, InputStream> entry : streams.entrySet()) {
            this.monitorMap.put(entry.getKey(), this.createStreamMonitor(entry.getValue(), encoding, process));
        }
        for (OutputStreamMonitor monitor : this.monitorMap.values()) {
            monitor.startMonitoring();
        }
    }

    private String getEncoding(IProcess process) {
        String encoding = process.getLaunch().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public IStreamMonitor getStreamMonitor(String streamIdentifier) {
        return (IStreamMonitor)this.monitorMap.get(streamIdentifier);
    }

    public String[] getStreamIdentifers() {
        return this.monitorMap.keySet().toArray(new String[this.monitorMap.size()]);
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.getStreamMonitor("ID_STANDARD_ERROR_STREAM");
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.getStreamMonitor("ID_STANDARD_OUTPUT_STREAM");
    }

    public void write(String input) throws IOException {
        throw new IOException("not supported");
    }

    protected OutputStreamMonitor createStreamMonitor(InputStream stream, String encoding, IProcess process) {
        return new OutputStreamMonitor(stream, encoding);
    }
}

